
const { remote, ipcRenderer } = require('electron')


const dark = `
html, body, .intro {
    height: 100%;
    width: 100%;
    background-color: #000 !important;
}

.intro ul li {
    color: #fff !important;
}

.intro .history tr .version .number {
    color: #fff !important;
}

.intro .history tr .version .date {
    color: #fff !important;
}
`

function inject (cssStr) {
    try {
        const head = document.getElementsByTagName('head')[0]

        const injectId = 'inject-style-tag'
        const injectTag = document.getElementById(injectId)
        if (injectTag) {
            head.removeChild(injectTag)
        }
        if (cssStr) {
            const injectStyle = document.createElement('style')
            injectStyle.id = injectId
            injectStyle.setAttribute('type', 'text/css')
            injectStyle.appendChild(document.createTextNode(cssStr))
            head.appendChild(injectStyle)
        } else {
            console.warn('[P] no cssStr to inject.')
        }
        
    } catch (err) {
        console.error('[P] inject css error:', err)
    }
}

function injectCss () {
    const map = new Map()
        .set('light', '')
        .set('dark', dark)

    const appConfig = remote.getGlobal('$AppConfig')
    const { theme } = appConfig
    console.log('[P] inject theme:', theme)
    inject(map.get(theme))
}

ipcRenderer.on('refresh-theme', () => {
    injectCss()
})

if (document.addEventListener) {
const loadedCallback = () => {
    console.log('[Preload] DOMContentLoaded.')
    document.removeEventListener('DOMContentLoaded', loadedCallback, false)
    injectCss()
}
document.addEventListener('DOMContentLoaded', loadedCallback)
}